;------------------------------------------------------------------------
; Panasonic 3DO
; FourDO v1.0.6.3 alpha r208
; by djvj
; 1.2
;
; Notes:
; Download xpath from http://www.autohotkey.net/~Titan/dl/xpath.zip and extract the xpath.ahk into your Hyperspin directory
; xpath is needed because AutoHotKey does not natively support reading/writing of XML files
; This emu only supports iso images
; If your bios file is called fz10_rom.bin, rename it to fz10.rom, it should be placed in the same dir as the emu exe.
; On first launch, FourDO will ask you to point it to the fz10.rom. After you do that, exit the emu and select a game in HS and it should work.
;------------------------------------------------------------------------

LoadingScreen = true
Fullscreen = true


#Include xpath.ahk

; This gets rid of the emu window that pops up on launch
If ( loadingScreen = "true" ) {
		Gui +AlwaysOnTop -Caption +ToolWindow
		Gui Color, Black
		Gui Show, x0 y0 h%A_ScreenHeight% w%A_ScreenWidth%
	}

; Update settings file via script because the emu doesn't support CLI loading of games
settingsPath = %emuPath%FourDO.settings
newromPath = %romPath%%romName%%romExtension%
xpath_load(emuXML, settingsPath ) ; need to read the existing xml otherwise xpath deletes all existing nodes
xpath(emuXML, "/Settings/GameRomFile/text()", newromPath) ; update node with the rom
xpath(emuXML, "/Settings/GameRomSourceType/text()", 1) ; enable setting to autoload game on start

; Enable Fullscreen
If ( Fullscreen = "true" )
	xpath(emuXML, "/Settings/WindowFullScreen/text()", "True")
Else
	xpath(emuXML, "/Settings/WindowFullScreen/text()", "False")

xpath_save(emuXML, settingsPath) ; write new XML

Run, %executable%, %emuPath%
WinWaitActive, 4DO
Process, WaitClose, %executable%

ExitApp

CloseProcess:
	WinClose, 4DO
Return